// *************************************************************************
//                            PicUSB.h                             
// *************************************************************************

#IFNDEF __USB_DESCRIPTORS__
#DEFINE __USB_DESCRIPTORS__

#include <usb.h>

// =========================================================================
//  Configuracin:
// 				Descriptor
//  			Interface
//				Clase
//				EndPoint
// =========================================================================

#define 	USB_TOTAL_CONFIG_LEN      32 								// Config + interface + clase + endpoint

// -------------------------------------------------------------------------
//  Configuracin del descriptor
// -------------------------------------------------------------------------
	char const USB_CONFIG_DESC[] = {
		USB_DESC_CONFIG_LEN,     										// Longitud del descriptor de la configuracin
		USB_DESC_CONFIG_TYPE,         									// Constante de la configuracin (0x02)
		USB_TOTAL_CONFIG_LEN,0,  										// Tamao de todos los datos de la configuracin
		1,      														// N de interfaces que soporta el perifrico
		0x01,                											// Identificador de esta configuracin (Por si hay varias configuraciones)
		0x00,                											// Indice de la cadena de descripccin para esta configuracin
		0xC0,                											// Bit 6=1 si est autoalimentado, 
																		// Bit 5=1 si soporta wakeup remoto, 
																		// Bits 0-4 reserved y Bit7=1
		0x32,                											// Mxima corriente requerida del bus (0x32 = 100mA)
// -------------------------------------------------------------------------
//  Configuracin de la interface
// -------------------------------------------------------------------------
		USB_DESC_INTERFACE_LEN,  										// Longitud del descriptor de la interface
		USB_DESC_INTERFACE_TYPE,      									// Constante de la interface (0x04)
		0x00,                											// Identificador de esta interface  (Por si hay varias interfaces)
        0x00,                											// Opcin alternativa
		2,       														// N de endpoints, no cuenta el endpoint 0.
		0xFF,                											// Cdigo de clase, FF = vendor defined
		0xFF,                											// Cdigo de subclase, FF = vendor
        0xFF,                											// Cdigo de protocolo, FF = vendor
        0x00,                											// Indice de la cadena de descripccin para esta interface

// -------------------------------------------------------------------------
//  Configuracin del endpoint EP1_IN
// -------------------------------------------------------------------------
		USB_DESC_ENDPOINT_LEN, 											// Longitud del descriptor del endpoint
		USB_DESC_ENDPOINT_TYPE,     									// Constante del endpoint (0x05)
		0x81,              												// N de endpoint y direccin (0x81 = EP1 IN)
		0x02,              												// Tipo de transferencia: (0 control, 1 iso, 2 bulk, 3 interrupt)
        USB_EP1_TX_SIZE,0x00,         									// Mximo tamao de paquete soportado
		0x01,              												// Intervalo en ms. (Solo para transferencias de interrupcin)

// -------------------------------------------------------------------------
//  Configuracin del endpoint EP1_OUT
// -------------------------------------------------------------------------
		USB_DESC_ENDPOINT_LEN, 											// Longitud del descriptor del endpoint
		USB_DESC_ENDPOINT_TYPE,     									// Constante del endpoint (0x05)
		0x01,              												// N de endpoint y direccin (0x01 = EP1 OUT)
		0x02,              												// Tipo de transferencia: (0 control, 1 iso, 2 bulk, 3 interrupt)
		USB_EP1_RX_SIZE,0x00,         									// Mximo tamao de paquete soportado
		0x01,              												// Intervalo en ms. (Solo para transferencias de interrupcin)
  };

// =========================================================================
// Constantes para un solo perifrico
// =========================================================================

#define USB_NUM_HID_INTERFACES   0
#define USB_MAX_NUM_INTERFACES   1

const char USB_NUM_INTERFACES[USB_NUM_CONFIGURATIONS]={1};

#if (sizeof(USB_CONFIG_DESC) != USB_TOTAL_CONFIG_LEN)
	#error USB_TOTAL_CONFIG_LEN not defined correctly
#endif


// =========================================================================
//	Descriptor del perifrico
// =========================================================================

char const USB_DEVICE_DESC[] ={
	USB_DESC_DEVICE_LEN,          										// La longitud de la descripccin
	0x01,                												// Constante del DEVICE (0x01)
	0x10,0x01,           												// Versin de usb en bcd
	0x00,                												// Cdigo de clase (Si es 0, clase.  FF vendor)
	0x00,                												// Cdigo de subclase
	0x00,                												// Cdigo de protocolo
	USB_MAX_EP0_PACKET_LENGTH,   										// Tamao mximo para el endpoint 0.
	0xD8,0x04,           												// Id del vendor (0x04D8 es Microchip)
	0x11,0x00,           												// Id del Producto (Le gusta el 11)
	0x01,0x00,           												// N de perifrico
	0x01,                												// Indice de la cadena de descripcin del fabricante 
	0x02,                												// Indice de la cadena de descripcin del producto
	0x00,                												// Indice de la cadena de descripcin del n de serie
	USB_NUM_CONFIGURATIONS   											// N de configuraciones posibles
	};


// =========================================================================
//	Cadenas de descripccin
//
//  SOporta solo 10 strings (0 al 9)
//
// =========================================================================

// -------------------------------------------------------------------------
// 	Offset de las distintas cadenas 
//  Offset[0] es el comienzo de la cadena 0, Offset[1] el de la 1, etc.
// -------------------------------------------------------------------------

const char USB_STRING_DESC_OFFSET[]={0,4,12};

#define USB_STRING_DESC_COUNT sizeof(USB_STRING_DESC_OFFSET)

char const USB_STRING_DESC[]={
	// string 0
	4, 																	// Longitud de la cadena 
    USB_DESC_STRING_TYPE, 												// Tipo de descriptor 0x03 (STRING)
    0x09,0x04,   														// Definido por Microsoft para US-English

   	// string 1 La compaia del producto
	8, 																	// Longitud de la cadena 
    USB_DESC_STRING_TYPE, 												// Tipo de descriptor 0x03 (STRING)
	'J',0,																// J1M
    '1',0,
    'M',0,
    
   	//string 2 Nombre del dispositivo
	22, 																// Longitud de la cadena 
    USB_DESC_STRING_TYPE, 												// Tipo de descriptor 0x03 (STRING)
	'J',0,																// J1M PicUSB
    '1',0,
    'M',0,
    ' ',0,
    'P',0,
    'i',0,
    'c',0,
    'U',0,
    'S',0,
    'B',0
};

#ENDIF
